<?php
/**
 * XenForo Add-on Merge Double User Post BBCode
 *
 * @category XenForo Add-on
 * @package    XfRu_MergeDoubleUserPost
 * @copyright  Copyright (c) 2010 XF-Russia. (http://www.xf-russia.ru)
 * @license
 * @version   $Id: Base.php 11 2010-10-16 18:52:52Z pepelac $ $Date: 2010-10-16 20:52:52 +0200 (Sat, 16 Oct 2010) $ $Revision: 11 $
 * @author Pepelac
 *
 */

class XfRu_MergeDoubleUserPost_BbCode_Formatter_Base extends XFCP_XfRu_MergeDoubleUserPost_BbCode_Formatter_Base
{
    protected $tags;

    public function getTags()
    {
        $this->tags = parent::getTags();
        $this->tags['mergetime'] = array(
            'hasOption' => true,
            'optionRegex' => '/^([\d]{10})$/',
            'callback' => array($this, 'renderTagMergetime')
        );
        return $this->tags;
    }

    public function renderTagMergetime(array $tag, array $rendererStates)
    {
	    $dataTime = $tag['option'];
		// get add-on options
	    $xfOptions = XenForo_Application::get('options');
	    $rgb = $this->hex2RGB($xfOptions->XfRu_DPP_Timestamp_Spacer_Color, true);

	    $params = array(
		    'font_size' => 	$this->getFontSize($xfOptions->XfRu_DPP_Timestamp_Spacer_Fontsize),
			'font_color' => ($rgb) ? $rgb : '192, 192, 192',
			'text' => $xfOptions->XfRu_DPP_Timestamp_Spacer_Text,
	    );

	    $tag = '<span style="color:rgb('.$params['font_color'].'); font-size:'.$params['font_size'].'">'.$params['text'].'</span>';
	    $abbr = XenForo_Template_Helper_Core::dateTime($dataTime, 'html');

		$tag = sprintf($tag, $abbr);
        return $tag;
    }


	private function hex2RGB($hexStr, $returnAsString = false, $seperator = ',')
	{
		/**
		 * only for now, later will use JS colorpicker from XF
		 */

		$hexStr = preg_replace("/[^0-9A-Fa-f]/", '', $hexStr); // Gets a proper hex string
		$rgbArray = array();
		if (strlen($hexStr) == 6)
		{ //If a proper hex code, convert using bitwise operation. No overhead... faster
			$colorVal = hexdec($hexStr);
			$rgbArray['red'] = 0xFF & ($colorVal >> 0x10);
			$rgbArray['green'] = 0xFF & ($colorVal >> 0x8);
			$rgbArray['blue'] = 0xFF & $colorVal;
		} elseif (strlen($hexStr) == 3) { //if shorthand notation, need some string manipulations
			$rgbArray['red'] = hexdec(str_repeat(substr($hexStr, 0, 1), 2));
			$rgbArray['green'] = hexdec(str_repeat(substr($hexStr, 1, 1), 2));
			$rgbArray['blue'] = hexdec(str_repeat(substr($hexStr, 2, 1), 2));
		} else {
			return false; //Invalid hex color code
		}
        return $returnAsString ? implode($seperator, $rgbArray) : $rgbArray; // returns the rgb string or the associative array
	}

	private function getFontSize($size)
	{
		$fontSize = '';
		switch ($size)
		{
			case 1 : $fontSize = 'xx-small'; break;
			case 2 : $fontSize = 'x-small'; break;
			case 3 : $fontSize = 'small'; break;
			case 4 : $fontSize = 'medium'; break;
			case 5 : $fontSize = 'large'; break;
			case 6 : $fontSize = 'x-large'; break;
			case 7 : $fontSize = 'xx-large'; break;
			default : $fontSize = 'x-small';  break; // default value 2
		}
	    return $fontSize;
	}
}